import { CommonModule } from '@angular/common';
import { Component, OnInit } from '@angular/core';
import { MatTabsModule } from '@angular/material/tabs';
import MySongs from '../../assets/data/mySongs.json';
import { Song } from '../song';
@Component({
  selector: 'app-detail',
  imports: [CommonModule,MatTabsModule],
  templateUrl: './detail.html',
  styleUrl: './detail.css'
})
export class Detail implements OnInit{

  songs: Song[] = [];
  selectedSong: Song | null = null;

  ngOnInit(): void {
      this.loadSongs();
  }

  loadSongs(): void{
    this.songs = (MySongs as any).songs;
  }

  selectSong(index: number): void{
    this.selectedSong = this.songs[index];
  }
}
